/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;

public class MatrixStacker {
    public static final Vector3d center = VecHelper.getCenterOf((Vector3i)BlockPos.field_177992_a);
    static MatrixStacker instance;
    MatrixStack ms;

    public static MatrixStacker of(MatrixStack ms) {
        if (instance == null) {
            instance = new MatrixStacker();
        }
        MatrixStacker.instance.ms = ms;
        return instance;
    }

    public MatrixStacker restoreIdentity() {
        MatrixStack.Entry entry = this.ms.func_227866_c_();
        entry.func_227870_a_().func_226591_a_();
        entry.func_227872_b_().func_226119_c_();
        return this;
    }

    public MatrixStacker rotate(Direction axis, float radians) {
        if (radians == 0.0f) {
            return this;
        }
        this.ms.func_227863_a_(axis.func_229386_k_().func_229193_c_(radians));
        return this;
    }

    public MatrixStacker rotate(double angle, Direction.Axis axis) {
        Vector3f vec = axis == Direction.Axis.X ? Vector3f.field_229179_b_ : (axis == Direction.Axis.Y ? Vector3f.field_229181_d_ : Vector3f.field_229183_f_);
        return this.multiply(vec, angle);
    }

    public MatrixStacker rotateX(double angle) {
        return this.multiply(Vector3f.field_229179_b_, angle);
    }

    public MatrixStacker rotateY(double angle) {
        return this.multiply(Vector3f.field_229181_d_, angle);
    }

    public MatrixStacker rotateZ(double angle) {
        return this.multiply(Vector3f.field_229183_f_, angle);
    }

    public MatrixStacker centre() {
        return this.translate(center);
    }

    public MatrixStacker unCentre() {
        return this.translateBack(center);
    }

    public MatrixStacker translate(Vector3i vec) {
        this.ms.func_227861_a_((double)vec.func_177958_n(), (double)vec.func_177956_o(), (double)vec.func_177952_p());
        return this;
    }

    public MatrixStacker translate(Vector3d vec) {
        this.ms.func_227861_a_(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        return this;
    }

    public MatrixStacker translateBack(Vector3d vec) {
        this.ms.func_227861_a_(-vec.field_72450_a, -vec.field_72448_b, -vec.field_72449_c);
        return this;
    }

    public MatrixStacker translate(double x, double y, double z) {
        this.ms.func_227861_a_(x, y, z);
        return this;
    }

    public MatrixStacker multiply(Quaternion quaternion) {
        this.ms.func_227863_a_(quaternion);
        return this;
    }

    public MatrixStacker nudge(int id) {
        long randomBits = (long)id * 31L * 493286711L;
        randomBits = randomBits * randomBits * 4392167121L + randomBits * 98761L;
        float xNudge = (((float)(randomBits >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float yNudge = (((float)(randomBits >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float zNudge = (((float)(randomBits >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        this.ms.func_227861_a_((double)xNudge, (double)yNudge, (double)zNudge);
        return this;
    }

    public MatrixStacker multiply(Vector3f axis, double angle) {
        if (angle == 0.0) {
            return this;
        }
        this.ms.func_227863_a_(axis.func_229187_a_((float)angle));
        return this;
    }

    public MatrixStacker push() {
        this.ms.func_227860_a_();
        return this;
    }

    public MatrixStacker pop() {
        this.ms.func_227865_b_();
        return this;
    }

    public MatrixStack unwrap() {
        return this.ms;
    }
}

