/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render.backend.instancing;

import com.simibubi.create.foundation.render.backend.Backend;
import com.simibubi.create.foundation.render.backend.MaterialType;
import com.simibubi.create.foundation.render.backend.MaterialTypes;
import com.simibubi.create.foundation.render.backend.core.ModelData;
import com.simibubi.create.foundation.render.backend.core.OrientedData;
import com.simibubi.create.foundation.render.backend.gl.BasicProgram;
import com.simibubi.create.foundation.render.backend.gl.shader.ShaderCallback;
import com.simibubi.create.foundation.render.backend.instancing.IDynamicInstance;
import com.simibubi.create.foundation.render.backend.instancing.IFlywheelWorld;
import com.simibubi.create.foundation.render.backend.instancing.IInstanceRendered;
import com.simibubi.create.foundation.render.backend.instancing.ITickableInstance;
import com.simibubi.create.foundation.render.backend.instancing.InstancedModel;
import com.simibubi.create.foundation.render.backend.instancing.InstancedTileRenderRegistry;
import com.simibubi.create.foundation.render.backend.instancing.RenderMaterial;
import com.simibubi.create.foundation.render.backend.instancing.TileEntityInstance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public abstract class InstancedTileRenderer<P extends BasicProgram> {
    protected ArrayList<TileEntity> queuedAdditions = new ArrayList(64);
    protected Map<TileEntity, TileEntityInstance<?>> instances = new HashMap();
    protected Map<TileEntity, ITickableInstance> tickableInstances = new HashMap<TileEntity, ITickableInstance>();
    protected Map<TileEntity, IDynamicInstance> dynamicInstances = new HashMap<TileEntity, IDynamicInstance>();
    protected Map<MaterialType<?>, RenderMaterial<P, ?>> materials = new HashMap();
    protected int frame;
    protected int tick;

    protected InstancedTileRenderer() {
        this.registerMaterials();
    }

    public abstract BlockPos getOriginCoordinate();

    public abstract void registerMaterials();

    public void tick(double cameraX, double cameraY, double cameraZ) {
        ++this.tick;
        int cX = (int)cameraX;
        int cY = (int)cameraY;
        int cZ = (int)cameraZ;
        if (this.tickableInstances.size() > 0) {
            for (ITickableInstance instance : this.tickableInstances.values()) {
                int dZ;
                int dY;
                if (!instance.decreaseTickRateWithDistance()) {
                    instance.tick();
                    continue;
                }
                BlockPos pos = instance.getWorldPosition();
                int dX = pos.func_177958_n() - cX;
                if (this.tick % this.getUpdateDivisor(dX, dY = pos.func_177956_o() - cY, dZ = pos.func_177952_p() - cZ) != 0) continue;
                instance.tick();
            }
        }
    }

    public void beginFrame(ActiveRenderInfo info, double cameraX, double cameraY, double cameraZ) {
        ++this.frame;
        this.processQueuedAdditions();
        Vector3f look = info.func_227996_l_();
        float lookX = look.func_195899_a();
        float lookY = look.func_195900_b();
        float lookZ = look.func_195902_c();
        int cX = (int)cameraX;
        int cY = (int)cameraY;
        int cZ = (int)cameraZ;
        if (this.dynamicInstances.size() > 0) {
            for (IDynamicInstance dyn : this.dynamicInstances.values()) {
                if (!dyn.decreaseFramerateWithDistance()) {
                    dyn.beginFrame();
                    continue;
                }
                if (!this.shouldTick(dyn.getWorldPosition(), lookX, lookY, lookZ, cX, cY, cZ)) continue;
                dyn.beginFrame();
            }
        }
    }

    public void render(RenderType layer, Matrix4f viewProjection, double camX, double camY, double camZ) {
        this.render(layer, viewProjection, camX, camY, camZ, null);
    }

    public void render(RenderType layer, Matrix4f viewProjection, double camX, double camY, double camZ, ShaderCallback<P> callback) {
        for (RenderMaterial<P, ?> material : this.materials.values()) {
            if (!material.canRenderInLayer(layer)) continue;
            material.render(layer, viewProjection, camX, camY, camZ, callback);
        }
    }

    public <M extends InstancedModel<?>> RenderMaterial<P, M> getMaterial(MaterialType<M> materialType) {
        return this.materials.get(materialType);
    }

    public RenderMaterial<P, InstancedModel<ModelData>> getTransformMaterial() {
        return this.getMaterial(MaterialTypes.TRANSFORMED);
    }

    public RenderMaterial<P, InstancedModel<OrientedData>> getOrientedMaterial() {
        return this.getMaterial(MaterialTypes.ORIENTED);
    }

    @Nullable
    public <T extends TileEntity> TileEntityInstance<? super T> getInstance(T tile, boolean create) {
        if (!Backend.canUseInstancing()) {
            return null;
        }
        TileEntityInstance<?> instance = this.instances.get(tile);
        if (instance != null) {
            return instance;
        }
        if (create && this.canCreateInstance(tile)) {
            return this.createInternal(tile);
        }
        return null;
    }

    public <T extends TileEntity> void onLightUpdate(T tile) {
        TileEntityInstance<T> instance;
        if (!Backend.canUseInstancing()) {
            return;
        }
        if (tile instanceof IInstanceRendered && (instance = this.getInstance(tile, false)) != null) {
            instance.updateLight();
        }
    }

    public <T extends TileEntity> void add(T tile) {
        if (!Backend.canUseInstancing()) {
            return;
        }
        if (tile instanceof IInstanceRendered) {
            this.addInternal(tile);
        }
    }

    public <T extends TileEntity> void update(T tile) {
        TileEntityInstance<T> instance;
        if (!Backend.canUseInstancing()) {
            return;
        }
        if (tile instanceof IInstanceRendered && (instance = this.getInstance(tile, false)) != null) {
            if (instance.shouldReset()) {
                this.removeInternal(tile, instance);
                this.createInternal(tile);
            } else {
                instance.update();
            }
        }
    }

    public <T extends TileEntity> void remove(T tile) {
        if (!Backend.canUseInstancing()) {
            return;
        }
        if (tile instanceof IInstanceRendered) {
            this.removeInternal(tile);
        }
    }

    public synchronized <T extends TileEntity> void queueAdd(T tile) {
        if (!Backend.canUseInstancing()) {
            return;
        }
        this.queuedAdditions.add(tile);
    }

    protected synchronized void processQueuedAdditions() {
        if (this.queuedAdditions.size() > 0) {
            this.queuedAdditions.forEach(this::addInternal);
            this.queuedAdditions.clear();
        }
    }

    protected boolean shouldTick(BlockPos worldPos, float lookX, float lookY, float lookZ, int cX, int cY, int cZ) {
        int dZ;
        int dY;
        int dX = worldPos.func_177958_n() - cX;
        float dot = ((float)dX + lookX * 2.0f) * lookX + ((float)(dY = worldPos.func_177956_o() - cY) + lookY * 2.0f) * lookY + ((float)(dZ = worldPos.func_177952_p() - cZ) + lookZ * 2.0f) * lookZ;
        if (dot < 0.0f) {
            return false;
        }
        return this.frame % this.getUpdateDivisor(dX, dY, dZ) == 0;
    }

    protected int getUpdateDivisor(int dX, int dY, int dZ) {
        int dSq = dX * dX + dY * dY + dZ * dZ;
        return dSq / 1024 + 1;
    }

    private void addInternal(TileEntity tile) {
        this.getInstance(tile, true);
    }

    private <T extends TileEntity> void removeInternal(T tile) {
        TileEntityInstance<T> instance = this.getInstance(tile, false);
        if (instance != null) {
            this.removeInternal(tile, instance);
        }
    }

    private void removeInternal(TileEntity tile, TileEntityInstance<?> instance) {
        instance.remove();
        this.instances.remove(tile);
        this.dynamicInstances.remove(tile);
        this.tickableInstances.remove(tile);
    }

    private <T extends TileEntity> TileEntityInstance<? super T> createInternal(T tile) {
        TileEntityInstance<T> renderer = InstancedTileRenderRegistry.instance.create(this, tile);
        if (renderer != null) {
            renderer.updateLight();
            this.instances.put(tile, renderer);
            if (renderer instanceof IDynamicInstance) {
                this.dynamicInstances.put(tile, (IDynamicInstance)((Object)renderer));
            }
            if (renderer instanceof ITickableInstance) {
                this.tickableInstances.put(tile, (ITickableInstance)((Object)renderer));
            }
        }
        return renderer;
    }

    public void invalidate() {
        for (RenderMaterial<P, ?> material : this.materials.values()) {
            material.delete();
        }
        this.instances.clear();
        this.dynamicInstances.clear();
        this.tickableInstances.clear();
    }

    public boolean canCreateInstance(TileEntity tile) {
        if (tile.func_145837_r()) {
            return false;
        }
        World world = tile.func_145831_w();
        if (world == null) {
            return false;
        }
        if (world.func_175623_d(tile.func_174877_v())) {
            return false;
        }
        if (world == Minecraft.func_71410_x().field_71441_e) {
            BlockPos pos = tile.func_174877_v();
            IBlockReader existingChunk = world.func_225522_c_(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
            return existingChunk != null;
        }
        return world instanceof IFlywheelWorld && ((IFlywheelWorld)world).supportsFlywheel();
    }
}

