/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render.backend.gl.shader;

import com.simibubi.create.foundation.render.backend.gl.attrib.IVertexAttrib;
import com.simibubi.create.foundation.render.backend.gl.shader.GlProgram;
import com.simibubi.create.foundation.render.backend.gl.shader.ShaderConstants;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.util.ResourceLocation;

public class ProgramSpec<P extends GlProgram> {
    public final ResourceLocation name;
    public final ResourceLocation vert;
    public final ResourceLocation frag;
    public final ShaderConstants defines;
    public final GlProgram.ProgramFactory<P> factory;
    public final ArrayList<IVertexAttrib> attributes;
    public final boolean fogSensitive;

    public static <P extends GlProgram> Builder<P> builder(String name, GlProgram.ProgramFactory<P> factory) {
        return ProgramSpec.builder(new ResourceLocation("create", name), factory);
    }

    public static <P extends GlProgram> Builder<P> builder(ResourceLocation name, GlProgram.ProgramFactory<P> factory) {
        return new Builder<P>(name, factory);
    }

    public ProgramSpec(ResourceLocation name, ResourceLocation vert, ResourceLocation frag, GlProgram.ProgramFactory<P> factory, ShaderConstants defines, ArrayList<IVertexAttrib> attributes, boolean fogSensitive) {
        this.name = name;
        this.vert = vert;
        this.frag = frag;
        this.defines = defines;
        this.factory = factory;
        this.attributes = attributes;
        this.fogSensitive = fogSensitive;
    }

    public ResourceLocation getVert() {
        return this.vert;
    }

    public ResourceLocation getFrag() {
        return this.frag;
    }

    public static class Builder<P extends GlProgram> {
        private ResourceLocation vert;
        private ResourceLocation frag;
        private ShaderConstants defines = ShaderConstants.EMPTY;
        private boolean fogSensitive = true;
        private final ResourceLocation name;
        private final GlProgram.ProgramFactory<P> factory;
        private final ArrayList<IVertexAttrib> attributes;

        public Builder(ResourceLocation name, GlProgram.ProgramFactory<P> factory) {
            this.name = name;
            this.factory = factory;
            this.attributes = new ArrayList();
        }

        public Builder<P> setVert(ResourceLocation vert) {
            this.vert = vert;
            return this;
        }

        public Builder<P> setFrag(ResourceLocation frag) {
            this.frag = frag;
            return this;
        }

        public Builder<P> setDefines(ShaderConstants defines) {
            this.defines = defines;
            return this;
        }

        public Builder<P> setFogSensitive(boolean fogSensitive) {
            this.fogSensitive = fogSensitive;
            return this;
        }

        public <A extends Enum<A>> Builder<P> addAttributes(Class<A> attributeEnum) {
            this.attributes.addAll(Arrays.asList(attributeEnum.getEnumConstants()));
            return this;
        }

        public ProgramSpec<P> createProgramSpec() {
            return new ProgramSpec<P>(this.name, this.vert, this.frag, this.factory, this.defines, this.attributes, this.fogSensitive);
        }
    }
}

