/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render.backend.gl;

import com.simibubi.create.foundation.render.backend.Backend;
import com.simibubi.create.foundation.render.backend.gl.GlObject;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.lwjgl.opengl.GL20;

public class GlBuffer
extends GlObject {
    protected final int bufferType;

    public GlBuffer(int bufferType) {
        this.setHandle(GL20.glGenBuffers());
        this.bufferType = bufferType;
    }

    public int getBufferType() {
        return this.bufferType;
    }

    public void bind() {
        GL20.glBindBuffer((int)this.bufferType, (int)this.handle());
    }

    public void unbind() {
        GL20.glBindBuffer((int)this.bufferType, (int)0);
    }

    public void with(Consumer<GlBuffer> action) {
        this.bind();
        action.accept(this);
        this.unbind();
    }

    public void map(int length, Consumer<ByteBuffer> upload) {
        Backend.compat.mapBuffer(this.bufferType, 0, length, upload);
    }

    public void map(int offset, int length, Consumer<ByteBuffer> upload) {
        Backend.compat.mapBuffer(this.bufferType, offset, length, upload);
    }

    @Override
    protected void deleteInternal(int handle) {
        GL20.glDeleteBuffers((int)handle);
    }
}

