/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.content;

import com.simibubi.create.foundation.ponder.PonderStoryBoardEntry;
import com.simibubi.create.foundation.ponder.content.PonderChapter;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PonderChapterRegistry {
    private final Map<String, Pair<PonderChapter, List<PonderStoryBoardEntry>>> chapters = new HashMap<String, Pair<PonderChapter, List<PonderStoryBoardEntry>>>();

    public void addStoriesToChapter(@Nonnull PonderChapter chapter, PonderStoryBoardEntry ... entries) {
        this.chapters.get(chapter.getId()).getSecond().addAll(Arrays.asList(entries));
    }

    PonderChapter addChapter(@Nonnull PonderChapter chapter) {
        this.chapters.put(chapter.getId(), Pair.of(chapter, new ArrayList()));
        return chapter;
    }

    @Nullable
    PonderChapter getChapter(String id) {
        Pair<PonderChapter, List<PonderStoryBoardEntry>> pair = this.chapters.get(id);
        if (pair == null) {
            return null;
        }
        return pair.getFirst();
    }

    public List<PonderChapter> getAllChapters() {
        return this.chapters.values().stream().map(Pair::getFirst).collect(Collectors.toList());
    }

    public List<PonderStoryBoardEntry> getStories(PonderChapter chapter) {
        return this.chapters.get(chapter.getId()).getSecond();
    }
}

