/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.item;

import com.google.common.base.Strings;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.AllSections;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.WipScription;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.FontHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.Language;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TextProcessing;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.MinecraftForgeClient;

public class TooltipHelper {
    public static final int maxWidthPerLine = 200;
    public static final Map<String, ItemDescription> cachedTooltips = new HashMap<String, ItemDescription>();
    public static com.mojang.bridge.game.Language cachedLanguage;
    private static boolean gogglesMode;
    private static final Map<Item, Supplier<String>> tooltipReferrals;

    public static IFormattableTextComponent holdShift(ItemDescription.Palette color, boolean highlighted) {
        return Lang.translate("tooltip.holdForDescription", Lang.translate("tooltip.keyShift", new Object[0]).func_240699_a_(TextFormatting.GRAY)).func_240699_a_(TextFormatting.DARK_GRAY);
    }

    public static void addHint(List<ITextComponent> tooltip, String hintKey, Object ... messageParams) {
        ITextComponent spacing = IHaveGoggleInformation.componentSpacing;
        tooltip.add((ITextComponent)spacing.func_230531_f_().func_230529_a_((ITextComponent)Lang.translate(hintKey + ".title", new Object[0])).func_240699_a_(TextFormatting.GOLD));
        TranslationTextComponent hint = Lang.translate(hintKey, new Object[0]);
        List<ITextComponent> cutComponent = TooltipHelper.cutTextComponent((ITextComponent)hint, TextFormatting.GRAY, TextFormatting.WHITE);
        for (ITextComponent component : cutComponent) {
            tooltip.add((ITextComponent)spacing.func_230531_f_().func_230529_a_(component));
        }
    }

    public static void referTo(IItemProvider item, Supplier<? extends IItemProvider> itemWithTooltip) {
        tooltipReferrals.put(item.func_199767_j(), () -> ((IItemProvider)itemWithTooltip.get()).func_199767_j().func_77658_a());
    }

    public static void referTo(IItemProvider item, String string) {
        tooltipReferrals.put(item.func_199767_j(), () -> string);
    }

    @Deprecated
    public static List<String> cutString(ITextComponent s, TextFormatting defaultColor, TextFormatting highlightColor) {
        return TooltipHelper.cutString(s.func_150261_e(), defaultColor, highlightColor, 0);
    }

    @Deprecated
    public static List<String> cutString(String s, TextFormatting defaultColor, TextFormatting highlightColor, int indent) {
        String markedUp = s.replaceAll("_([^_]+)_", highlightColor + "$1" + defaultColor);
        LinkedList<String> words = new LinkedList<String>();
        BreakIterator iterator = BreakIterator.getLineInstance(MinecraftForgeClient.getLocale());
        iterator.setText(markedUp);
        int start = iterator.first();
        int end = iterator.next();
        while (end != -1) {
            String word = markedUp.substring(start, end);
            words.add(word);
            start = end;
            end = iterator.next();
        }
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        List<String> lines = FontHelper.cutString(font, markedUp, 200);
        String lineStart = Strings.repeat((String)" ", (int)indent);
        ArrayList<String> formattedLines = new ArrayList<String>(lines.size());
        String format = defaultColor.toString();
        for (String line : lines) {
            String formattedLine = format + lineStart + line;
            formattedLines.add(formattedLine);
        }
        return formattedLines;
    }

    public static List<ITextComponent> cutStringTextComponent(String c, TextFormatting defaultColor, TextFormatting highlightColor) {
        return TooltipHelper.cutTextComponent((ITextComponent)new StringTextComponent(c), defaultColor, highlightColor, 0);
    }

    public static List<ITextComponent> cutTextComponent(ITextComponent c, TextFormatting defaultColor, TextFormatting highlightColor) {
        return TooltipHelper.cutTextComponent(c, defaultColor, highlightColor, 0);
    }

    public static List<ITextComponent> cutStringTextComponent(String c, TextFormatting defaultColor, TextFormatting highlightColor, int indent) {
        return TooltipHelper.cutTextComponent((ITextComponent)new StringTextComponent(c), defaultColor, highlightColor, indent);
    }

    public static List<ITextComponent> cutTextComponent(ITextComponent c, TextFormatting defaultColor, TextFormatting highlightColor, int indent) {
        String s;
        String markedUp = s = TooltipHelper.getUnformattedDeepText(c);
        LinkedList<String> words = new LinkedList<String>();
        BreakIterator iterator = BreakIterator.getLineInstance(MinecraftForgeClient.getLocale());
        iterator.setText(markedUp);
        int start = iterator.first();
        int end = iterator.next();
        while (end != -1) {
            String word = markedUp.substring(start, end);
            words.add(word);
            start = end;
            end = iterator.next();
        }
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        LinkedList<String> lines = new LinkedList<String>();
        StringBuilder currentLine = new StringBuilder();
        int width = 0;
        for (String word : words) {
            int newWidth = font.func_78256_a(word.replaceAll("_", ""));
            if (width + newWidth > 200) {
                if (width > 0) {
                    String line = currentLine.toString();
                    lines.add(line);
                    currentLine = new StringBuilder();
                    width = 0;
                } else {
                    lines.add(word);
                    continue;
                }
            }
            currentLine.append(word);
            width += newWidth;
        }
        if (width > 0) {
            lines.add(currentLine.toString());
        }
        StringTextComponent lineStart = new StringTextComponent(Strings.repeat((String)" ", (int)indent));
        lineStart.func_240699_a_(defaultColor);
        ArrayList<ITextComponent> formattedLines = new ArrayList<ITextComponent>(lines.size());
        Couple<TextFormatting> f = Couple.create(highlightColor, defaultColor);
        boolean currentlyHighlighted = false;
        for (String string : lines) {
            String[] split;
            IFormattableTextComponent currentComponent = lineStart.func_230531_f_();
            for (String part : split = string.split("_")) {
                currentComponent.func_230529_a_((ITextComponent)new StringTextComponent(part).func_240699_a_(f.get(currentlyHighlighted)));
                currentlyHighlighted = !currentlyHighlighted;
            }
            formattedLines.add((ITextComponent)currentComponent);
            currentlyHighlighted = !currentlyHighlighted;
        }
        return formattedLines;
    }

    private static void checkLocale() {
        Language currentLanguage = Minecraft.func_71410_x().func_135016_M().func_135041_c();
        if (cachedLanguage != currentLanguage) {
            cachedTooltips.clear();
            cachedLanguage = currentLanguage;
        }
    }

    public static boolean hasTooltip(ItemStack stack, PlayerEntity player) {
        String key;
        TooltipHelper.checkLocale();
        boolean hasGlasses = AllItems.GOGGLES.isIn(player.func_184582_a(EquipmentSlotType.HEAD));
        if (hasGlasses != gogglesMode) {
            gogglesMode = hasGlasses;
            cachedTooltips.clear();
        }
        if (cachedTooltips.containsKey(key = TooltipHelper.getTooltipTranslationKey(stack))) {
            return cachedTooltips.get(key) != ItemDescription.MISSING;
        }
        return TooltipHelper.findTooltip(stack);
    }

    public static ItemDescription getTooltip(ItemStack stack) {
        ItemDescription itemDescription;
        TooltipHelper.checkLocale();
        String key = TooltipHelper.getTooltipTranslationKey(stack);
        if (cachedTooltips.containsKey(key) && (itemDescription = cachedTooltips.get(key)) != ItemDescription.MISSING) {
            return itemDescription;
        }
        return null;
    }

    private static boolean findTooltip(ItemStack stack) {
        String key = TooltipHelper.getTooltipTranslationKey(stack);
        if (I18n.func_188566_a((String)key)) {
            cachedTooltips.put(key, TooltipHelper.buildToolTip(key, stack));
            return true;
        }
        cachedTooltips.put(key, ItemDescription.MISSING);
        return false;
    }

    private static ItemDescription buildToolTip(String translationKey, ItemStack stack) {
        int i;
        AllSections module = AllSections.of(stack);
        if (I18n.func_135052_a((String)translationKey, (Object[])new Object[0]).equals("WIP")) {
            return new WipScription(module.getTooltipPalette());
        }
        ItemDescription tooltip = new ItemDescription(module.getTooltipPalette());
        String summaryKey = translationKey + ".summary";
        if (I18n.func_188566_a((String)summaryKey)) {
            tooltip = tooltip.withSummary((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)summaryKey, (Object[])new Object[0])));
        }
        for (i = 1; i < 100; ++i) {
            String conditionKey = translationKey + ".condition" + i;
            String behaviourKey = translationKey + ".behaviour" + i;
            if (!I18n.func_188566_a((String)conditionKey)) break;
            if (i == 1) {
                tooltip.getLinesOnShift().add((ITextComponent)new StringTextComponent(""));
            }
            tooltip.withBehaviour(I18n.func_135052_a((String)conditionKey, (Object[])new Object[0]), I18n.func_135052_a((String)behaviourKey, (Object[])new Object[0]));
        }
        for (i = 1; i < 100; ++i) {
            String controlKey = translationKey + ".control" + i;
            String actionKey = translationKey + ".action" + i;
            if (!I18n.func_188566_a((String)controlKey)) break;
            tooltip.withControl(I18n.func_135052_a((String)controlKey, (Object[])new Object[0]), I18n.func_135052_a((String)actionKey, (Object[])new Object[0]));
        }
        return tooltip.createTabs();
    }

    public static String getTooltipTranslationKey(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (tooltipReferrals.containsKey(item)) {
            return tooltipReferrals.get(item).get() + ".tooltip";
        }
        return item.func_77667_c(stack) + ".tooltip";
    }

    private static int getComponentLength(ITextComponent component) {
        AtomicInteger l = new AtomicInteger();
        TextProcessing.func_238343_a_((ITextProperties)component, (Style)Style.field_240709_b_, (s, style, charConsumer) -> {
            l.getAndIncrement();
            return true;
        });
        return l.get();
    }

    public static String getUnformattedDeepText(ITextComponent component) {
        StringBuilder b = new StringBuilder();
        b.append(component.getString());
        component.func_150253_a().forEach(c -> b.append(TooltipHelper.getUnformattedDeepText(c)));
        return b.toString();
    }

    static {
        tooltipReferrals = new HashMap<Item, Supplier<String>>();
    }
}

