/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data;

import com.simibubi.create.repack.registrate.providers.DataGenContext;
import com.simibubi.create.repack.registrate.providers.RegistrateBlockstateProvider;
import com.simibubi.create.repack.registrate.providers.RegistrateItemModelProvider;
import com.simibubi.create.repack.registrate.util.nullness.NonNullBiConsumer;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;

public class AssetLookup {
    public static ModelFile partialBaseModel(DataGenContext<?, ?> ctx, RegistrateBlockstateProvider prov, String ... suffix) {
        String string = "/block";
        for (String suf : suffix) {
            string = string + "_" + suf;
        }
        String location = "block/" + ctx.getName() + string;
        return prov.models().getExistingFile(prov.modLoc(location));
    }

    public static ModelFile standardModel(DataGenContext<?, ?> ctx, RegistrateBlockstateProvider prov) {
        return prov.models().getExistingFile(prov.modLoc("block/" + ctx.getName()));
    }

    public static <I extends BlockItem> ItemModelBuilder customItemModel(DataGenContext<Item, I> ctx, RegistrateItemModelProvider prov) {
        return prov.blockItem(() -> ((BlockItem)ctx.getEntry()).func_179223_d(), "/item");
    }

    public static <I extends BlockItem> NonNullBiConsumer<DataGenContext<Item, I>, RegistrateItemModelProvider> customItemModel(String ... folders) {
        return (c, p) -> {
            String path = "block";
            for (String string : folders) {
                path = path + "/" + ("_".equals(string) ? c.getName() : string);
            }
            p.withExistingParent(c.getName(), p.modLoc(path));
        };
    }

    public static Function<BlockState, ModelFile> forPowered(DataGenContext<?, ?> ctx, RegistrateBlockstateProvider prov) {
        return state -> (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u) != false ? AssetLookup.partialBaseModel(ctx, prov, "powered") : AssetLookup.partialBaseModel(ctx, prov, new String[0]);
    }

    public static Function<BlockState, ModelFile> forPowered(DataGenContext<?, ?> ctx, RegistrateBlockstateProvider prov, String path) {
        return state -> prov.models().getExistingFile(prov.modLoc("block/" + path + ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u) != false ? "_powered" : "")));
    }

    public static Function<BlockState, ModelFile> withIndicator(DataGenContext<?, ?> ctx, RegistrateBlockstateProvider prov, Function<BlockState, ModelFile> baseModelFunc, IntegerProperty property) {
        return state -> {
            ResourceLocation baseModel = ((ModelFile)baseModelFunc.apply((BlockState)state)).getLocation();
            Integer integer = (Integer)state.func_177229_b((Property)property);
            return ((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_" + integer, baseModel)).texture("indicator", "block/indicator/" + integer);
        };
    }

    public static String getOxidizedModel(String name, int level) {
        return "block/oxidized/" + name + "_" + level;
    }

    public static <T extends Item> NonNullBiConsumer<DataGenContext<Item, T>, RegistrateItemModelProvider> existingItemModel() {
        return (c, p) -> p.getExistingFile(p.modLoc("item/" + c.getName()));
    }

    public static <T extends Item> NonNullBiConsumer<DataGenContext<Item, T>, RegistrateItemModelProvider> itemModelWithPartials() {
        return (c, p) -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)p.withExistingParent("item/" + c.getName(), p.modLoc("item/" + c.getName() + "/item"));
        };
    }
}

