/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.zapper;

import com.simibubi.create.content.curiosities.zapper.ZapperRenderHandler;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class ZapperBeamPacket
extends SimplePacketBase {
    public Vector3d start;
    public Vector3d target;
    public Hand hand;
    public boolean self;

    public ZapperBeamPacket(Vector3d start, Vector3d target, Hand hand, boolean self) {
        this.start = start;
        this.target = target;
        this.hand = hand;
        this.self = self;
    }

    public ZapperBeamPacket(PacketBuffer buffer) {
        this.start = new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        this.target = new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        this.hand = buffer.readBoolean() ? Hand.MAIN_HAND : Hand.OFF_HAND;
        this.self = buffer.readBoolean();
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.writeDouble(this.start.field_72450_a);
        buffer.writeDouble(this.start.field_72448_b);
        buffer.writeDouble(this.start.field_72449_c);
        buffer.writeDouble(this.target.field_72450_a);
        buffer.writeDouble(this.target.field_72448_b);
        buffer.writeDouble(this.target.field_72449_c);
        buffer.writeBoolean(this.hand == Hand.MAIN_HAND);
        buffer.writeBoolean(this.self);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (Minecraft.func_71410_x().field_71439_g.func_213303_ch().func_72438_d(this.start) > 100.0) {
                return;
            }
            ZapperRenderHandler.addBeam(new ZapperRenderHandler.LaserBeam(this.start, this.target).followPlayer(this.self, this.hand == Hand.MAIN_HAND));
            if (this.self) {
                ZapperRenderHandler.shoot(this.hand);
            } else {
                ZapperRenderHandler.playSound(this.hand, new BlockPos(this.start));
            }
        }));
        context.get().setPacketHandled(true);
    }
}

